/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.annotation.Immutable;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.protocol.HttpAsyncRequestExecutionHandler;
import org.apache.http.nio.protocol.MessageState;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class HttpAsyncRequestExecutor
implements NHttpClientEventHandler {
    public static final String HTTP_HANDLER = "http.nio.exchange-handler";
    static final String HTTP_EXCHANGE_STATE = "http.nio.http-exchange-state";

    @Override
    public void connected(NHttpClientConnection conn, Object attachment) throws IOException, HttpException {
        State state = new State();
        HttpContext context = conn.getContext();
        context.setAttribute(HTTP_EXCHANGE_STATE, (Object)state);
        this.requestReady(conn);
    }

    @Override
    public void closed(NHttpClientConnection conn) {
        State state = this.getState(conn);
        HttpAsyncRequestExecutionHandler<?> handler = this.getHandler(conn);
        if (state == null || handler != null && handler.isDone()) {
            this.closeHandler(handler);
        }
        if (state != null) {
            state.reset();
        }
    }

    @Override
    public void exception(NHttpClientConnection conn, Exception cause) {
        this.shutdownConnection(conn);
        HttpAsyncRequestExecutionHandler<?> handler = this.getHandler(conn);
        if (handler != null) {
            handler.failed(cause);
        } else {
            this.log(cause);
        }
    }

    @Override
    public void requestReady(NHttpClientConnection conn) throws IOException, HttpException {
        State state = this.ensureNotNull(this.getState(conn));
        if (state.getRequestState() != MessageState.READY) {
            return;
        }
        HttpAsyncRequestExecutionHandler<?> handler = this.getHandler(conn);
        if (handler != null && handler.isDone()) {
            this.closeHandler(handler);
            state.reset();
            handler = null;
        }
        if (handler == null) {
            return;
        }
        HttpContext context = handler.getContext();
        context.setAttribute("http.connection", (Object)conn);
        HttpRequest request = handler.generateRequest();
        context.setAttribute("http.request", (Object)request);
        conn.setSocketTimeout(HttpConnectionParams.getSoTimeout((HttpParams)request.getParams()));
        HttpProcessor httppocessor = handler.getHttpProcessor();
        httppocessor.process(request, context);
        state.setRequest(request);
        conn.submitRequest(request);
        if (request instanceof HttpEntityEnclosingRequest) {
            if (((HttpEntityEnclosingRequest)request).expectContinue()) {
                int timeout = conn.getSocketTimeout();
                state.setTimeout(timeout);
                timeout = request.getParams().getIntParameter("http.protocol.wait-for-continue", 3000);
                conn.setSocketTimeout(timeout);
                state.setRequestState(MessageState.ACK_EXPECTED);
            } else {
                state.setRequestState(MessageState.BODY_STREAM);
            }
        } else {
            handler.requestCompleted(context);
            state.setRequestState(MessageState.COMPLETED);
        }
    }

    @Override
    public void outputReady(NHttpClientConnection conn, ContentEncoder encoder) throws IOException {
        State state = this.ensureNotNull(this.getState(conn));
        HttpAsyncRequestExecutionHandler<?> handler = this.ensureNotNull(this.getHandler(conn));
        if (state.getRequestState() == MessageState.ACK_EXPECTED) {
            conn.suspendOutput();
            return;
        }
        HttpContext context = handler.getContext();
        handler.produceContent(encoder, conn);
        state.setRequestState(MessageState.BODY_STREAM);
        if (encoder.isCompleted()) {
            handler.requestCompleted(context);
            state.setRequestState(MessageState.COMPLETED);
        }
    }

    @Override
    public void responseReceived(NHttpClientConnection conn) throws HttpException, IOException {
        State state = this.ensureNotNull(this.getState(conn));
        HttpAsyncRequestExecutionHandler<?> handler = this.ensureNotNull(this.getHandler(conn));
        HttpResponse response = conn.getHttpResponse();
        HttpRequest request = state.getRequest();
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode < 200) {
            if (statusCode != 100) {
                throw new ProtocolException("Unexpected response: " + response.getStatusLine());
            }
            if (state.getRequestState() == MessageState.ACK_EXPECTED) {
                int timeout = state.getTimeout();
                conn.setSocketTimeout(timeout);
                conn.requestOutput();
                state.setRequestState(MessageState.ACK);
            }
            return;
        }
        state.setResponse(response);
        if (state.getRequestState() == MessageState.ACK_EXPECTED) {
            int timeout = state.getTimeout();
            conn.setSocketTimeout(timeout);
            conn.resetOutput();
            state.setRequestState(MessageState.COMPLETED);
        } else if (state.getRequestState() == MessageState.BODY_STREAM) {
            conn.resetOutput();
            conn.suspendOutput();
            state.setRequestState(MessageState.COMPLETED);
            state.invalidate();
        }
        handler.responseReceived(response);
        HttpContext context = handler.getContext();
        HttpProcessor httpprocessor = handler.getHttpProcessor();
        context.setAttribute("http.response", (Object)response);
        httpprocessor.process(response, context);
        state.setResponseState(MessageState.BODY_STREAM);
        if (!this.canResponseHaveBody(request, response)) {
            response.setEntity(null);
            conn.resetInput();
            this.processResponse(conn, state, handler);
        }
    }

    @Override
    public void inputReady(NHttpClientConnection conn, ContentDecoder decoder) throws IOException {
        State state = this.ensureNotNull(this.getState(conn));
        HttpAsyncRequestExecutionHandler<?> handler = this.ensureNotNull(this.getHandler(conn));
        handler.consumeContent(decoder, conn);
        state.setResponseState(MessageState.BODY_STREAM);
        if (decoder.isCompleted()) {
            this.processResponse(conn, state, handler);
        }
    }

    @Override
    public void endOfInput(NHttpClientConnection conn) throws IOException {
        State state = this.getState(conn);
        if (state != null && state.getRequestState().compareTo(MessageState.READY) != 0) {
            state.invalidate();
            HttpAsyncRequestExecutionHandler<?> handler = this.getHandler(conn);
            handler.failed((Exception)new ConnectionClosedException("Connection closed"));
        }
        if (conn.getSocketTimeout() <= 0) {
            conn.setSocketTimeout(1000);
        }
        conn.close();
    }

    @Override
    public void timeout(NHttpClientConnection conn) throws IOException {
        State state = this.getState(conn);
        if (state != null) {
            if (state.getRequestState() == MessageState.ACK_EXPECTED) {
                int timeout = state.getTimeout();
                conn.setSocketTimeout(timeout);
                conn.requestOutput();
                state.setRequestState(MessageState.BODY_STREAM);
                return;
            }
            state.invalidate();
            HttpAsyncRequestExecutionHandler<?> handler = this.getHandler(conn);
            if (handler != null) {
                handler.failed(new SocketTimeoutException());
                handler.close();
            }
        }
        if (conn.getStatus() == 0) {
            conn.close();
            if (conn.getStatus() == 1) {
                conn.setSocketTimeout(250);
            }
        } else {
            conn.shutdown();
        }
    }

    protected void log(Exception ex) {
    }

    private State getState(NHttpConnection conn) {
        return (State)conn.getContext().getAttribute(HTTP_EXCHANGE_STATE);
    }

    private State ensureNotNull(State state) {
        if (state == null) {
            throw new IllegalStateException("HTTP exchange state is null");
        }
        return state;
    }

    private HttpAsyncRequestExecutionHandler<?> getHandler(NHttpConnection conn) {
        return (HttpAsyncRequestExecutionHandler)conn.getContext().getAttribute(HTTP_HANDLER);
    }

    private HttpAsyncRequestExecutionHandler<?> ensureNotNull(HttpAsyncRequestExecutionHandler<?> handler) {
        if (handler == null) {
            throw new IllegalStateException("HTTP exchange handler is null");
        }
        return handler;
    }

    private void shutdownConnection(NHttpConnection conn) {
        try {
            conn.shutdown();
        }
        catch (IOException ex) {
            this.log(ex);
        }
    }

    private void closeHandler(HttpAsyncRequestExecutionHandler<?> handler) {
        if (handler != null) {
            try {
                handler.close();
            }
            catch (IOException ioex) {
                this.log(ioex);
            }
        }
    }

    private void processResponse(NHttpClientConnection conn, State state, HttpAsyncRequestExecutionHandler<?> handler) throws IOException {
        HttpContext context = handler.getContext();
        if (state.isValid()) {
            ConnectionReuseStrategy connReuseStrategy;
            HttpRequest request = state.getRequest();
            HttpResponse response = state.getResponse();
            String method = request.getRequestLine().getMethod();
            int status = response.getStatusLine().getStatusCode();
            if (!(method.equalsIgnoreCase("CONNECT") && status < 300 || (connReuseStrategy = handler.getConnectionReuseStrategy()).keepAlive(response, context))) {
                conn.close();
            }
        } else {
            conn.close();
        }
        handler.responseCompleted(context);
        state.reset();
    }

    private boolean canResponseHaveBody(HttpRequest request, HttpResponse response) {
        String method = request.getRequestLine().getMethod();
        int status = response.getStatusLine().getStatusCode();
        if (method.equalsIgnoreCase("HEAD")) {
            return false;
        }
        if (method.equalsIgnoreCase("CONNECT") && status < 300) {
            return false;
        }
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }

    static class State {
        private volatile MessageState requestState = MessageState.READY;
        private volatile MessageState responseState = MessageState.READY;
        private volatile HttpRequest request;
        private volatile HttpResponse response;
        private volatile boolean valid = true;
        private volatile int timeout;

        State() {
        }

        public MessageState getRequestState() {
            return this.requestState;
        }

        public void setRequestState(MessageState state) {
            this.requestState = state;
        }

        public MessageState getResponseState() {
            return this.responseState;
        }

        public void setResponseState(MessageState state) {
            this.responseState = state;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void setRequest(HttpRequest request) {
            this.request = request;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public void setResponse(HttpResponse response) {
            this.response = response;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public void reset() {
            this.responseState = MessageState.READY;
            this.requestState = MessageState.READY;
            this.response = null;
            this.request = null;
            this.timeout = 0;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void invalidate() {
            this.valid = false;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("request state: ");
            buf.append((Object)this.requestState);
            buf.append("; request: ");
            if (this.request != null) {
                buf.append(this.request.getRequestLine());
            }
            buf.append("; response state: ");
            buf.append((Object)this.responseState);
            buf.append("; response: ");
            if (this.response != null) {
                buf.append(this.response.getStatusLine());
            }
            buf.append("; valid: ");
            buf.append(this.valid);
            buf.append(";");
            return buf.toString();
        }
    }
}

